<?php
require_once 'header.php';

$id = $_GET['id'] ?? null;

$item = null;
foreach ($slides as $slide) {
    if ($slide['id'] == $id) {
        $item = $slide;
        break;
    }
}
?>
<body>
    <?php if ($item): ?>
    <div class="store-item">
        <!-- Thumbnail -->
        <section>
            <img src="<?= htmlspecialchars($item['paintPhoto'] ?: 'testimagepaint.png') ?>" alt="<?= htmlspecialchars($item['paintName']) ?>">
        </section>
        <!-- Name & price -->
        <h3><?= htmlspecialchars($item['paintName']) ?></h3>
        <p>Prijs: €<?= htmlspecialchars($item['price']) ?></p>
        <p>Gewicht: <?= htmlspecialchars($item['grams']) ?>g</p>
        <p>Shine: <?= htmlspecialchars($item['shine']) ?></p>
        <p>Base: <?= htmlspecialchars($item['base']) ?></p>
        <p>Hoofdkleur: <?= htmlspecialchars($item['mainColorName']) ?></p>
        <!-- Mini swatches preview -->
        <div class="swatch-list">
            <?php foreach ($item['opts'] as $opt): ?>
                <div class="swatch" style="background:<?= htmlspecialchars($opt['hex']) ?>; width:16px; height:16px; "></div>
            <?php endforeach ?>
        </div>
        <!-- Tips -->
        <?php if (!empty($item['tips'])): ?>
            <div class="tips">
                <h4>Tips:</h4>
                <ul>
                    <?php foreach ($item['tips'] as $tip): ?>
                        <li><?= htmlspecialchars($tip) ?></li>
                    <?php endforeach ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>
    <?php else: ?>
        <div class="error-detail"><p >Product niet gevonden.</p></div> 
    <?php endif; ?>
</body>
<?php require_once 'footer.php'; ?>